<?php
/**
 * ConnectDaily Events Calendar Content Plugin 
 * 
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
defined('_JEXEC') or die;
$app=JFactory::getApplication();
$plugin=CDailyJoomlaPlugin::getInstance();
$data = $plugin->getPostData('type-data', 'json/list.js',array('request_number' => 'VIEWABLE_TYPES'));

if (!$data->wasSuccess()) {
    $app->enqueueMessage($data->error_message,'warning');
    $items=array();
} else {
    $set=json_decode($data->content);
    $items=$set->items;
}

$liReq=$plugin->getPostData('license-info','json/licenseInfo.js',array('request_number' => 'LICENSE_INFO'));
$locations=false;
$resources=false;
$multiCalendar=true;
$independentStyles=false;
if ($liReq->wasSuccess()) {
    $info=$liReq->getContentObject();
    $multiCalendar=$info->LicensedCalendars>1;
    $locations=$info->Locations;
    $resources=$info->ResourceManagement;
    $independentStyles=!$info->TieItemStyleToItemType;
}

?>
<script type="text/javascript">

CDaily["cd_codetype_onchange"]=function(control){
    var a="add_event_options by_method EndTimes filter listevents iframesize califrame fullcalendar simplelist".split(' ');
    var sClasses=jQuery(control.options[control.selectedIndex]).attr('data-elementclass');
    for (var i=0; i < a.length; i++) {
        jQuery('.'+a[i]).each(function(index) {
            jQuery(this).css("display",
                             sClasses.indexOf(a[i]) >=0 ? "inline-block" : "none"
                            );
        });
    }
};

jQuery(document).ready(function(){
    CDaily.cd_codetype_onchange(document.getElementById('IDcd_codetype'));
    CDaily.initForDropdownFromMethod(document.getElementById('IDcd_by_method'));
    });
CDaily["typeData"]=<?php echo $data->content; ?>;
</script>
<form name="myForm" class="cdSettingsForm">
    <!--    
        The Toolbar 

        Looking at the Joomla Editor "articles" plugin, it looks like you
        can't use the normal toolbar mechanism.
    -->
    <div class="btn-toolbar">
        <div class="btn-group" style="width: 100%;">
            <div class="btn-wrapper" style="float: left;">
            <label style="display: inline-block; margin-right: 1em;" for="IDcd_codetype"><?php echo JText::_('COM_CONNECTDAILY_SHORTCODE_TYPE'); ?></label>
            <select id="IDcd_codetype" name="cd_codetype" onchange="CDaily.cd_codetype_onchange(this);">
                <option data-elementclass="add_event_options" value="addevent">
                    <?php echo JText::_('COM_CONNECTDAILY_ADDEVENTFORM'); ?>
                </option>
                <option data-elementclass="by_method EndTimes listevents" value="detailedlist">
                    <?php echo JText::_('COM_CONNECTDAILY_INTEGRATIONWIZARDDETAILEDLIST'); ?>
                </option>
                <option data-elementclass="by_method EndTimes listevents simplelist" value="simplelist" selected>
                    <?php echo JText::_('COM_CONNECTDAILY_INTEGRATIONWIZARDSIMPLELIST'); ?>
                </option>
                <option data-elementclass="by_method" value="minicalendar">
                    <?php echo JText::_('COM_CONNECTDAILY_INTEGRATIONWIZARDMINICALENDAR'); ?>
                </option>
                <option data-elementclass="by_method fullcalendar" value="monthview">
                    <?php echo JText::_('COM_CONNECTDAILY_RESPONSIVECALENDAR'); ?>
                </option>
                <option value="filter"
                    data-elementclass="filter"
                    ><?php echo JText::_('COM_CONNECTDAILY_EVENTSFILTER'); ?>
                </option>
                <option data-elementclass="listevents by_method" value="search">
                    <?php echo JText::_('COM_CONNECTDAILY_SEARCH'); ?>
                </option>
                <option data-elementclass="" value="event">
                    <?php echo JText::_('COM_CONNECTDAILY_SINGLEEVENT'); ?>
                </option>
                <option data-elementclass="by_method" value="icalendar">
                    <?php echo JText::_('COM_CONNECTDAILY_ICALENDARLINK'); ?>
                </option>
                <option data-elementclass="by_method califrame iframesize" value="calendariframe">
                    <?php echo JText::_('COM_CONNECTDAILY_CALENDARIFRAME'); ?>
                </option>
            </select>
            </div>
            <div class="btn-wrapper"  id="toolbar-apply" style="float: left;">
                <button onclick="return CDaily.joomlaPluginInsert();" class="btn btn-small btn-success">
                    <span class="icon-checkmark"></span>
                    <?php echo JText::_('COM_CONNECTDAILY_INSERT'); ?>
                </button>
            </div>
            <div class="btn-wrapper"  id="toolbar-help" style="float: right; ">
                <button style="margin-right: 1em;" onclick="window.open('http://livedemo.mhsoftware.com/manual/en/pageFinder.html?page=JoomlaCalendarPlugin.html'); return false;" class="btn btn-small">
                    <span class="icon-help" title="Help"></span><?php echo JText::_('JTOOLBAR_HELP'); ?>
                </button>
            </div>
        </div>
    </div>
    <hr class="hr-condensed" />
    <!-- 
        The connectDaily Form Elements 
    -->
    <div id="CDShortCode" class="cdListEvents">
        <!--    List Events by/For Fields -->
        <fieldset id="fsCDailyEvents" class="FloatSettings by_method">
        <legend>
        <?php echo JText::_('COM_CONNECTDAILY_EVENTS'); ?>
        </legend>
        <dl>
            <dt><label for="IDcd_by_method"><?php echo JText::_('COM_CONNECTDAILY_SHOW_BY'); ?></label></dt>
            <dd>
            <select id="IDcd_by_method" name="cd_by_method" onchange="CDaily.initForDropdownFromMethod(this);">
<?php
     foreach ($items as $item) {
?>
                <option value="<?php echo $item->type_string; ?>"><?php echo $item->type_name; ?></option>
<?php
     }
?>
            </select>
            </dd>
            <dt><label for="ID_cd_by_id"><?php echo JText::_('COM_CONNECTDAILY_SHOW_FOR'); ?></label></dt>
            <dd>
            <select id="IDcd_by_id" name="cd_by_id">
                <option value="abc">Unused Value Overwritten by Init</option>
            </select>
            </dd>
            <dt><label class="califrame" for="IDcd_iframe_view"><?php echo JText::_('COM_CONNECTDAILY_CALENDAR_FORMAT'); ?>
            </label></dt>
            <dd>
            <select class="califrame" id="IDcd_iframe_view" name="cd_iframe_view">
                <option value="View.html"><?php echo JText::_('COM_CONNECTDAILY_DEFAULTCALENDARVIEW'); ?></option>
                <option value="ViewYear.html"><?php echo JText::_('COM_CONNECTDAILY_YEARVIEW'); ?></option>
                <option value="ViewMonth.html"><?php echo JText::_('COM_CONNECTDAILY_MONTHVIEW'); ?></option>
                <option value="ViewWeek.html"><?php echo JText::_('COM_CONNECTDAILY_WEEKVIEW'); ?></option>
                <option value="ViewDay.html"><?php echo JText::_('COM_CONNECTDAILY_DAYVIEW'); ?></option>
                <option value="ViewList.html"><?php echo JText::_('COM_CONNECTDAILY_LISTVIEW'); ?></option>
                <option value="ViewPlanner.html"><?php echo JText::_('COM_CONNECTDAILY_PLANNERVIEW'); ?></option>
            </select>
            </dd>
        </dl>
        </fieldset>
        <!--    List Events Settings    -->
        <fieldset id="fsCDailyListEvents" class="FloatSettings listevents">
        <legend>
        <?php echo JText::_('COM_CONNECTDAILY_LIST_SETTINGS'); ?>
        </legend>
        <dl>
            <dt><label for="IDcd_max_events"><?php echo JText::_('COM_CONNECTDAILY_MAX_EVENTS'); ?></label></dt>
            <dd><input id="IDcd_max_events" name="cd_max_events" type="number" value="6" min="1" step="1" style="width: 6em;"></dd>

            <dt><label for="IDcd_max_days"><?php echo JText::_('COM_CONNECTDAILY_MAX_DAYS'); ?></label></dt>
            <dd><input id="IDcd_max_days" name="cd_max_days" type="number" value="30" min="0" max="365" step="1" style="width: 6em;"></dd>

            <dd class="simplelist"><label>
            <input id="IDcd_show_starttimes" name="cd_show_starttimes" type="checkbox" value="1"> 
            <?php echo JText::_('COM_CONNECTDAILY_SHOWSTART'); ?>
            </label></dd> 

            <dd class="EndTimes"><label>
            <input id="IDcd_show_endtimes" name="cd_show_endtimes" type="checkbox" value="1"> 
            <?php echo JText::_('COM_CONNECTDAILY_SHOWEND'); ?>
            </label></dd> 

            <dt><?php echo JText::_('COM_CONNECTDAILY_RECURRING_EVENTS'); ?></dt>
            <dd><label>
            <input id="IDcd_allow_duplicates" name="cd_allow_duplicates" type="checkbox" value="1" checked> 
            <?php echo JText::_('COM_CONNECTDAILY_SHOW_ONCE'); ?>
            </label></dd> 
        </dl> 
        </fieldset> 
        <fieldset id="fsCDailyCalendarOptions" class="fullcalendar">
            <legend>
                <?php echo JText::_('COM_CONNECTDAILY_OPTIONS'); ?>
            </legend>
            <label>
                <input type="checkbox" name="cd_wrap_eventtitles" id="IDcd_wrap_eventtitles" value="1">
                <?php echo JText::_('COM_CONNECTDAILY_WRAPTITLES'); ?>
            </label>
            <label>
                <input type="checkbox" name="cd_enable_dropdown" id="IDcd_enable_dropdown" value="1">
                <?php echo JText::_('COM_CONNECTDAILY_ENABLE_SELECTDD'); ?>
            </label>
            <label>
                <input type="checkbox" name="cd_event_styles" id="IDcd_event_styles" value="1">
                <?php echo JText::_('COM_CONNECTDAILY_ENABLE_STYLES'); ?>
            </label>
        </fieldset>
        <!-- IFrame Size Settings --> 
        <fieldset id="fsCDailyIFrameSize" class="FloatSettings iframesize"> 
            <legend><?php echo JText::_('COM_CONNECTDAILY_IFRAMESIZE'); ?></legend> 
            <dl>
                <dt><label for="IDcd_height"><?php echo JText::_('COM_CONNECTDAILY_HEIGHT'); ?></label>
                <dd><input id="IDcd_height" name="cd_height" type="text" style="width: 6em;" value="1024px"> 
                <dt><label for="IDcd_width"><?php echo JText::_('COM_CONNECTDAILY_WIDTH'); ?></label>
                <dd><input id="IDcd_width" name="cd_width" type="text" style="width: 6em;" value="100%"> 
            </dl>
        </fieldset>
        <fieldset id="fsCDailyAddEventOptions" class="add_event_options">
        <label>
            <input type="checkbox" name="cd_allow_recurrence"  id="IDcd_allow_recurrence" value="1">
            <?php echo JText::_('COM_CONNECTDAILY_ALLOWRECURRENCE'); ?>
        </label>
        </fieldset>
        <!--
                Options for the Filter Shortcode.    
        -->
        <fieldset class="FloatSettings filter" id="fsCDailyFilterOptions">
        <label>
            <?php echo JText::_("COM_CONNECTDAILY_FILTERBY"); ?><br>
            <select id="IDcd_filter_by_method">
            <option value="item_type_id"><?php echo JText::_("COM_CONNECTDAILY_LISTBYTYPE"); ?></option>
<?php
     if ($independentStyles) {
         ?>
        <option value="style_id"><?php echo JText::_("COM_CONNECTDAILY_LISTBYSTYLE"); ?></option>
    <?php
     }
?>
<?php
     if ($multiCalendar) {
         ?>
        <option value="calendar_id"><?php echo JText::_("COM_CONNECTDAILY_LISTBYCALENDAR"); ?></option>
    <?php
     }
?>
<?php
     if ($locations) {
         ?>
        <option value="location_id"><?php echo JText::_("COM_CONNECTDAILY_LISTBYLOCATION"); ?></option>
    <?php
     }
?>
<?php
     if ($resources) {
         ?>
        <!-- <option value="resource_id"><?php echo JText::_("COM_CONNECTDAILY_LISTBYRESOURCE"); ?></option> -->
    <?php
     }
?>
            </select>
        </label><br>
        <label>
            <?php echo JText::_("COM_CONNECTDAILY_TITLE"); ?><br>
            <input type=text name="cd_filter_title" id="IDcd_filter_title" value="<?php echo JText::_("COM_CONNECTDAILY_FILTER"); ?>">
        </label><br>
        <label>
        <?php echo JText::_("COM_CONNECTDAILY_COLLAPSETHRESHOLD"); ?><br>
        <input size="4" type="number" min="0" id="IDcd_collapse_threshold"
            name="cd_collapse_threshold" value="6"></label>
        <br>
        <label>
            <?php echo JText::_("COM_CONNECTDAILY_COLLAPSELABEL"); ?><br>
            <input type=text name="cd_collapse_label" id="IDcd_collapse_label" value="(-)">
        </label><br>
        <label>
            <?php echo JText::_("COM_CONNECTDAILY_EXPANDLABEL"); ?><br>
            <input type=text name="cd_expand_label" id="IDcd_expand_label" value="(+)"><br>
        </label>
        </fieldset>
    </div>
</form>
<?php
