<?php 
/**
 * ConnectDaily Events Calendar Content Plugin 
 * 
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
defined('_JEXEC') or die; 
?>
<?php echo JText::_('COM_CONNECTDAILY_COMPONENT_SETTINGS'); ?>
<script type="text/javascript">
CDaily["ssoAjaxURL"]="<?php echo $this->ajaxURL; ?>";
</script>
<form class="cdSettingsForm" id="adminForm" name="adminForm" method="POST">
    <input type="hidden" name="form_submit" value="Y">
    <input type="hidden" name="task">
    <input type="hidden" name="option" value="com_connectdaily">
    <input type="hidden" name="cd_configured" value="$this->configuredSetting">
    <?php
    if (!$this->is_configured) {        
    ?>
    <fieldset id="fldSetProvisionOrUse" style="display: block; max-width: 70ex;">
        <label><input  onclick="return CDaily.toggleSettingsFieldSets();" type="radio" name="rgCalendarChoice" id="idCreateNewCalendar" value="create" checked>
        <?php echo JText::_('COM_CONNECTDAILY_CREATE_NEW_OPTION'); ?>
        </label><br>
        <label><input  onclick="return CDaily.toggleSettingsFieldSets();" type="radio" name="rgCalendarChoice" id="idConnectToExisting" value="use_existing">
        <?php echo JText::_('COM_CONNECTDAILY_USE_EXISTING'); ?>
        </label><br>
    </fieldset>

    <fieldset style="clear: both; display: block; max-width: 70ex; float: left;" ID="fldSetCreateNewCalendar">
    <legend><?php echo JText::_('COM_CONNECTDAILY_PROVISION_NEW_CALENDAR'); ?></legend>
    <dl>
        <dt><label for="idCDOrgName"><?php echo JText::_('COM_CONNECTDAILY_ORGNAME'); ?></label></dt>
        <dd><input type="text" id="idCDOrgName" name="organization_name" placeholder="<?php echo JText::_('COM_CONNECTDAILY_PH_REQUIRED'); ?>" value="<?php echo $this->plugin->getSiteDescription(); ?>"></dd>
        <dt><label for="idCDSiteURL"><?php echo JText::_('COM_CONNECTDAILY_SITEURL'); ?></label></dt>
        <dd><input type="text" id="idCDSiteURL" name="site_url" 
            placeholder="<?php echo JText::_('COM_CONNECTDAILY_PH_REQUIRED'); ?>" value="<?php echo $this->plugin->getSiteUrl(); ?>"></dd>

        <dt><label for="idCDEMail"><?php echo JText::_('COM_CONNECTDAILY_EMAILADDRESS'); ?></label></dt>
        <dd><input type="email" id="idCDEMail" name="provision_email" 
            value="<?php echo $this->email; ?>"></dd>

        <dt><?php echo JText::_("COM_CONNECTDAILY_SCHEDULEYOURRESOURCES"); ?></dt>
        <dd><label><input id="idCDProvisionExampleResourceManagement" type="checkbox" name="provision_resources" value="1">
                <?php echo JText::_("COM_CONNECTDAILY_PROVISIONEXAMPLERESOURCEMANAGEMENT"); ?>
            </label>
        </dd>
        <dt><?php echo JText::_("COM_CONNECTDAILY_PROVISIONPUBLICADD"); ?></dt>
        <dd>
            <label>
                <input id="idCDProvisionPublicAdd" type="checkbox" name="provision_publicadd" value="1">
                <?php echo JText::_("COM_CONNECTDAILY_PROVISIONPUBLICADD_DETAIL"); ?>
             </label>
        </dd>
<!--
        <dt><?php echo JText::_('COM_CONNECTDAILY_TERMSANDCONDITIONS'); ?></dt>
        <dd><label><input type="checkbox" id="idCDTC" name="chkCDTermsAndConditions" value="1">
        <?php echo $this->termsTxt; ?>
        </label>
        </dd>
-->
   <input type="hidden" id="idCDTC" name="chkCDTermsAndConditions" value="1">     
    </dl>
    </fieldset>
    <?php
    }
    ?>
    <div id="idJoomlaCDailySettings" style="display: <?php echo $this->is_configured ? "block" : "none"; ?>" >
        <fieldset class=FloatSettings id="fldSetConnectExistingCalendar">
        <legend>
            <?php echo JText::_('COM_CONNECTDAILY_GENERAL'); ?>
        </legend>
        <dl>
            <dt><label for="IDCDailyURL"><?php echo JText::_('COM_CONNECTDAILY_CALENDAR_URL'); ?></label>
            <dd><input type="url" id="IDCDailyURL" name="cdaily_url" size="50" value="<?php echo $this->settings->url; ?>" onChange="return CDaily.cdaily_url_onChange(this);">
            <dt><label for="IDCDailyUserName"><?php echo JText::_('COM_CONNECTDAILY_USERNAME'); ?></label></dt>
            <dd><input type="text" id="IDCDailyUserName" name="cdaily_username" placeholder="<?php echo JText::_('COM_CONNECTDAILY_PH_OPTIONAL'); ?>" value="<?php echo $this->settings->username; ?>"></dd>
            <dt><label for="IDCDailyPassword"><?php echo JText::_('COM_CONNECTDAILY_PASSWORD'); ?></label></dt>
            <dd><input type="text" id="IDCDailyPassword" name="cdaily_password" placeholder="<?php echo JText::_('COM_CONNECTDAILY_PH_OPTIONAL'); ?>" value="<?php echo $this->settings->password; ?>"></dd>
            <dt><label for="IDCDailySkipResourceTypes"><?php echo JText::_('COM_CONNECTDAILY_SKIP_RESOURCETYPES'); ?></label></dt>
            <dd><input type="text" id="IDCDailySkipResourceTypes" name="cdaily_skip_resource_types" value="<?php echo $this->settings->skip_resource_types; ?>"></dd>
            <dt><label><?php echo JText::_('COM_CONNECTDAILY_DISABLE_CACHING'); ?></label></dt>
            <dd><label><input style="margin-right: 1em;" type="checkbox" id="cdailyDisableCache" name="cdaily_disable_cache" value="1">
            <?php echo $this->cacheMsg; ?></label></dd>
            </dl>
        </fieldset>
        <fieldset class=FloatSettings id="IDCDailyDateTimeFormats">
            <legend>
                <?php echo JText::_('COM_CONNECTDAILY_DATETIMEFORMATS'); ?>
                
                <a class="icon-help" href="http://php.net/manual/en/function.date.php" target=_blank title="<?php echo JText::_('COM_CONNECTDAILY_DATETIME_FORMATTING'); ?>"></a>
            </legend>
            <dl>
                <dd><br><br></dd>
                <dt><label for="IDCDailyDateFormat"><?php echo JText::_('COM_CONNECTDAILY_DATEFORMAT'); ?></label></dt>
                <dd><input type="text" id="IDCDailyDateFormat" name="cdaily_date_format" value="<?php echo $this->settings->date_format; ?>"></dd>

                <dt><label for="IDCDailyTimeFormat"><?php echo JText::_('COM_CONNECTDAILY_TIMEFORMAT'); ?></label></dt>
                <dd><input type="text" id="IDCDailyTimeFormat" name="cdaily_time_format" value="<?php echo $this->settings->time_format; ?>"></dd>


                <dt><label for="IDCDailyDateTimeFormat"><?php echo JText::_('COM_CONNECTDAILY_DATETIME_FORMAT'); ?></label></dt>
                <dd><input type="text" id="IDCDailyDateTimeFormat" name="cdaily_datetime_format" value="<?php echo $this->settings->datetime_format; ?>"></dd>
                
                <dt><label for="IDCDailyStartOfWeek"><?php echo JText::_('COM_CONNECTDAILY_STARTINGDOW'); ?></label></dt>
                <dd><?php echo $this->getDaysOfWeekDropdown($this->language->getFirstDay(),$this->settings->start_of_week); ?></dd>
            </dl>
        </fieldset>
    </div>
</form>

<div class="CDpostbox" ID="CDailyInstructions" style="max-width: 70ex;  display: <?php echo $this->is_configured ? 'block;' : 'none;'?>">
    <h3>Settings Information</h3>
    <div>
    <h4>General</h4>
    <strong>Calendar URL</strong> This is the URL to your connectDaily Calendar. If
    you don&apos;t already have a calendar, select the radio group option <em>Create a new connectDaily Calendar system</em>.
    <p>
    <strong>User Name</strong> and <strong>Password</strong> are only required if
    the public cannot view the calendar, or you want to display a calendar the
    default public user does not have permission to.
    </p>
	    <p>
		    <strong>Skip Resource Types</strong>
		    By default, all resources assigned to an event are displayed. You can
		    <ol>
		    <li>Leave this blank to list all resources.
		    <li>Specify a comma-separated list of resource type names that should not be displayed
		    <li>Put an asterisk (*) in to skip all resources.
		    </ol>
    <p>
    <strong>Disable Caching</strong> By default, the plugin caches generated data
    for
	<?php echo CDailyPlugin::CACHE_PERIOD_SECONDS; ?> seconds. Caching the data makes
	your web site go faster and gives your users a better experience.  If you  edit
	your calendar, changes might not show up immediately. You can temporarily
	disable this by checking the box and saving.
    </p>


    <h4>Date and Time Formats</h4>
    <p>
    <strong>Formats</strong> are used when an event with a date and time is
    displayed. For information on formats, click on the ? icon.
    </p>
    <p><strong>Starting Day of Week</strong> is used when drawing a mini-calendar or full-sized calendar. It controls 
        what day is considered the <em>start</em> of the week. In the US it's Sunday, while in the UK and 
        most other countries, it's Monday.
        </p>

    </div>
</div>

<!--
display: <?php echo ($this->is_configured ? 'block' : 'none'); ?>;
-->
<div class="CDpostbox" ID="CDailyCreateInstructions" style="float: left; padding: 1em; max-width: 70ex; display: <?php echo $this->is_configured ? 'none;' : 'block;'?>">
    <h3>Instructions</h3>
    Use this form to create a new cloud-based calendar.
    <br><br>
    If you already have a connectDaily calendar, check the radio group option <em>Use an existing connectDaily Calendar System</em>.
    <br><br>
    The <b>Email Address</b> is used to send system messages, along with tips on using connectDaily. If you don't supply an Email address,
    you won't be able to reset the password on your cloud calendar.
    <br><br>
    You can learn more about connectDaily&apos;s cloud based calendar 
        <a href="http://www.mhsoftware.com/industries/developers/" target=_blank>
        here</a>.

</div>
<?php

echo $this->plugin->ajaxURLScript();
echo $this->plugin->getRequiredCaptions(array('Close'));
