<?php 
/**
 * ConnectDaily Events Calendar Content Plugin 
 * 
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
defined('_JEXEC') or die; 
?>
<?php echo $this->plugin->ajaxURLScript(); ?>
<div class="CDpostbox" id="CDailyInstructions">
    <img id="CDailyLogo" src="<?php echo $this->plugin->getSiteUrl(); ?>libraries/connectdaily/images/ConnectDailyLogo.svg">
    <h3>Events Calendar Overview</h3>
    <div>
        <p>
        connectDaily Events Calendar is a cloud based calendar system. This component provides an
        interface to that cloud based service. connectDaily is incredibly
        powerful and full-featured. It includes:
        </p>
        <ul>
        <li>Multi-User with Configurable Security</li>
        <li>Event Approvals</li>
        <li>Text or EMail Notifications and Reminders</li>
        <li>Resource Management</li>
        <li>Social Networking Support</li>
        <li>Mobile Device Support</li>
        <li>Data Import/Export</li>
        <ul>
        <li>iCalendar, RSS, JSON, and CSV Export</li>
        <li>iCalendar, RSS, and CSV Import. Supports recurring imports from
        remote urls.</li>
        <li>Ticketing services including EventBrite and BrownPaperTicket</li>
        </ul>
        <li>Time Zone Support</li>
        <li>Outstanding Joomla! Support</li>
        <li>High Performance - Supports 10&apos;s of thousands of events.</li>
        <li>See a complete <a href="http://www.mhsoftware.com/connect-daily-events-calendar-features/"
            target="_blank">list of features</a>.</li>
        </ul>
        <p>
        For complete information about connectDaily, <a
            href="http://www.mhsoftware.com/industries/developers/" target="_blank">visit our web
        site</a>.
        </p>
        <p>
        This plugin provides
        </p>
        <ul>
        <li>Responsive Full-sized Calendar
        <li>Mini-Calendar
        <li>Responsive Detailed List of Events
        <li>Responsive Simple List of Events
        <li>Responsive Event Creation Form</li>
        <li>iCalendar Link Shortcode</li>
        <li>IFRAME Shortcodes for other calendar formats into your design.
        </ul>
        <p>
        In addition to our best-in-class feature set, we offer outstanding
        support which includes unlimited telephone support to paid customers.
        </p>
        <?php
        if (empty($this->settings->url)) {
        ?>

            <p>
            To get started, click on <em>Settings</em> in the menu.
            </p>
        <?php
        }
        ?>
    </div>
</div>
<div class="CDSidebar">
    <h3>4 Steps to Get Started</h3>
    <table class="StepList">
        <tr>
            <td><span class="icon-checkmark"></span></td>
            <td>1.</td><td>Install the plugin.</td>
        </tr>
        <tr>
            <td><span  class="icon-<?php echo $this->is_configured ? 'checkmark' : 'NONE'; ?>"></span></td>
            <td>2.</td><td>Create or configure your calendar on the <a href="index.php?option=com_connectdaily&task=settings.showsettings">options page</a>.
            </td>
        </tr>
        <tr>
            <td><span  class="icon-<?php echo ($this->plugin->isUsed() && $this->is_configured) ? 'checkmark' : 'NONE'; ?>"></span></td>
            <td>3.</td><td> Add the widgets or shortcodes to your content or create a custom module.</td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td>4.</td><td>
            <?php
                  if ( $this->is_configured ) {
                     ?>
                <a href="javascript:CDaily.doSingleSignon();" >Add your events.</a>
                <?php
                 } else {
                 ?>
                         Add your events.                        
                     <?php
                 }
                 ?>

                                </td>
       </tr>
    </table>
</div>
<div class="CDSidebar">
    <h3>Links</h3>
    <ul>
        <li><a href="http://www.mhsoftware.com/industries/developers/" target=_blank>Extension Home Page</a></li>
        <li><a href="http://livedemo.mhsoftware.com/manual/en/pageFinder.html?page=JoomlaCalendarPlugin.html" target=_blank>Help</a></li>
        <li><a href="<?php echo CDailyJoomlaPlugin::TUTORIAL_URL?>" target=_blank>Tutorial Video</a></li>
        <li><a href="http://livedemo.mhsoftware.com/manual/en/pageFinder.html?page=JoomlaCalendarPluginFAQ.html" target=_blank>Extension FAQ</a></li>
        <li><a href="http://www.mhsoftware.com/contact/" target=_blank>Contact Sales</a></li>
        <li><a href="http://www.mhsoftware.com/support/" target=_blank>Contact Support</a></li>
    </ul>
</div>
<div class="CDSidebar">
    <h3>Testimonials</h3>
            I wanted to take the time to tell you how helpful you have been. Your product is 
            amazing and will add a great deal of value to my web site. Moreover, your 
            product is outperformed only by your customer service. I greatly appreciate the 
            fact that I was able to call you every time I needed assistance (I never had to 
            leave a message). MH Software should be the blueprint for every web-based 
            business.
            <br><br>
            <strong>Alex Fraser - CHR, ArtmasterStudios.com</strong>
</div>
<form name="adminForm" id="adminForm">
    <!-- this is a dummy necessary for toolbar buttons to work. -->
    <input type="hidden" name="task" value="settings.showsettings">
    <input type="hidden" name="option" value="com_connectdaily">
</form>
<script type="text/javascript">
CDaily["ssoAjaxURL"]="<?php echo $this->ajaxURL; ?>";
</script>

