<?php 

/**
 * @package         Google Structured Data Markup
 * @version         2.1.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die;
JHTML::_('behavior.modal'); 

?>

<div class="nr">

	<div class="nr-well well" style="max-width:550px;">
		<h4>
			<?php echo JText::_("GSD_INFORMATION") ?>
		</h4>
		<p>
			<a target="_blank" href="http://www.tassos.gr/joomla-extensions/google-structured-data-markup">
				<?php echo JText::_("GSD") ?>
				<?php echo NRFrameworkFunctions::getExtensionVersion("plg_system_gsd", true) ?>
			</a>
		</p>
		<p class="bg-primary"><?php echo JText::_("GSD_LIKE_EXTENSION") ?> <a target="_blank" href="http://extensions.joomla.org/extensions/extension/search-a-indexing/web-search/google-structured-data-markup"><?php echo JText::_("GSD_LEAVE_REVIEW") ?></a> 
			<a class="stars" target="_blank" href="http://extensions.joomla.org/extensions/extension/search-a-indexing/web-search/google-structured-data-markup">
				<span class="icon-star"></span>
				<span class="icon-star"></span>
				<span class="icon-star"></span>
				<span class="icon-star"></span>
				<span class="icon-star"></span>
			</a>
		</p>
		<?php echo JText::_("GSD_NEED_SUPPORT") ?> 
		<a target="_blank" href="http://www.tassos.gr/contact?s=BackEndSupport"><?php echo JText::_("GSD_DROP_EMAIL") ?></a>
	</div>

	<div class="nr-well well" style="max-width:550px;">
	<?php 
		$docsHome = "https://www.tassos.gr/joomla-extensions/google-structured-data-markup/docs/";
		$docs = array(
			"How to test your Structured Data" => "how-to-test-your-structured-data",
			"The Site Name Snippet" => "the-site-name-snippet",
			"The Sitelinks Searchbox Snippet" => "the-sitelinks-searchbox-snippet",
			"The Local Business Listing Snippet" => "the-local-business-listing-snippet",
			"The Articles Snippet" => "the-articles-snippet",
			"The Products Snippet" => "the-products-snippet",
			"The Events Snippet" => "the-events-snippet",

			"Structured Data not showing in Google" => "structured-data-not-showing-in-google",
			"Google's Guidelines on Proper Usage of Structured Data" => 'google-s-guidelines-on-proper-usage-of-structured-data'
		);
	?>
	<h4>
		<?php echo JText::_("NR_DOCUMENTATION"); ?>
	</h4>
	<ul>
		<?php foreach ($docs as $key => $doc) { ?>
		<li>
			<a target="_blank" href="<?php echo $docsHome . $doc ?>"><?php echo $key ?></a>
		</li>			
		<?php } ?>
	</ul>
	</div>

	<h4><?php echo JText::_("GSD_SPECIAL_THANKS") ?></h4>
	<p style="max-width:500px;">
		To <a target="_blank" href="https://twitter.com/heyjoecampbell">Joe Campbell (@heyjoecampbell)</a> for providing the concept of this extension. <br>Along with making it happen by donating his services to the project (graphics, writing, promotions, project management, and of course his legendary
	<a href="https://twitter.com/search?q=%23JFeedback&src=typd">#JFeedback</a>)
	</p>
	
	
	<hr>
	<h4>Consider a small donation</h4>
	<a href="https://www.paypal.com/cgi-bin/webscr?hosted_button_id=KUW8XCTXR8SRG&cmd=_s-xclick" target="_blank">
		<img src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif">
	</a>
	
	<hr>
	<p>&copy; <?php echo Date("Y") ?> - Tassos Marinos All Rights Reserved</p>
</div>

<style>
	.stars:hover {
		text-decoration: none;
	}
	.icon-star {
	    color: #fcac0a;
	    width: 7px;
	}
</style>