<?php
/**
 * ConnectDaily Events Calendar System Plugin 
 *  
 * This plugin hooks into the master event loop so that we can 
 * insert relevant messages in the right spot. For example, we 
 * want to display a hint on how to insert a short code on the 
 * content editor page. 
 *  
 * @package Joomla.Plugin 
 * @subpackage System.connectdaily 
 * @copyright (C) 2017 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (5/23/17) 
 */
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');
jimport('connectdaily.class-cdaily-plugin');
jimport('connectdaily.class-cdaily-joomla');

class plgSystemConnectDaily extends JPlugin {

    /** @var CDailyJoomlaPlugin $plugin  */
    private $plugin;

    public function __construct(&$subject, $params) {
        parent::__construct($subject, $params);
        $this->plugin = CDailyJoomlaPlugin::getInstance();
    }

    /**
     * Hook into the top level route system so I can display 
     * messages appropriately. 
     * 
     * @author gsexton (5/23/17)
     */
    function onAfterRoute() {
        try {
            $this->doAfterRoute();
        } catch (Exception $e) {
            $plugin->logError($e->getMessage());
        }
    }

    private function doAfterRoute() {
        $uri=JUri::getInstance();
        $a=$uri->getQuery(true);
        $user=JFactory::getUser();
        if (array_key_exists('option',$a)) {
            $option=$a['option'];
            $view=null;
            if (array_key_exists('view',$a)) {
                $view=$a['view'];
            }
            $layout=null;
            if (array_key_exists('layout',$a)) {
                $layout=$a['layout'];
            }
            switch ($option) {
            case 'com_content':
                if ($view=='article' && $layout=='edit' && $user!=null && $user->authorise('core.edit.own','com_content')) {
                    if (!$this->plugin->hasUserSeenHint('ShortCodeInsertion')) {
                        $tutorialURL=CDailyJoomlaPlugin::TUTORIAL_URL;
                        $imgPath=$this->plugin->getSiteUrl().'libraries/connectdaily/images/ShortCodeInsertionAnimation.gif';
                        $msg=sprintf(JText::_('COM_CONNECTDAILY_SHORTCODEINSERTION',false,false),$tutorialURL,$imgPath);
                        $dismiss=sprintf(JText::_('COM_CONNECTDAILY_DISMISSHINT'),"ShortCodeInsertion");
                        JFactory::getApplication()->enqueueMessage(
                            $msg.
                            $dismiss.
                            $this->plugin->ajaxURLScript());

                        $this->plugin->loadAdminScripts();
                    }
                }
                break;
            default:
                break;
            }
        }
    }

}

