<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.connectdaily
 *
 * @copyright   Copyright (C) 2016 MH Software, Inc. All rights
 *              reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * connectDaily Short Code Insertion Plugin - This was pretty 
 * much copied from the Article insertion plugin and then 
 * modified. 
 *  
 * @author George Sexton 
 */
class PlgButtonConnectDaily extends JPlugin {
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.1
     */
    protected $autoloadLanguage = true;

    /**
     * Display the button
     *
     * @param   string  $name  The name of the button to add
     *
     * @return array A four element array of (article_id, article_title, category_id, object)
     */
    public function onDisplay($name) {
        /*
         * Javascript to insert the short code 
         *  
         * View element calls jCDailyInsertShortCode when the dialog completes.
         * jCDailyInsertShortCode sends it to the editor, and closes the select 
         * frame.
         */
        $js = "function jCDailyInsertShortCode(tagContent){
            jInsertEditorText(tagContent, '" . $name . "');
            jModalClose();
        }";

        $doc = JFactory::getDocument();
        $doc->addScriptDeclaration($js);

        /*
         * Use the built-in element view to select the article.
         * Currently uses blank class.
         */
        $link = 'index.php?option=com_connectdaily&amp;task=shortcodes.shortcodes&amp;tmpl=component&amp;layout=modal&amp;' . JSession::getFormToken() . '=1';

        $button = new JObject;
        $button->modal = true;
        $button->class = 'btn';
        $button->link = $link;
        $button->text=JText::_('COM_CONNECTDAILY_CALENDAR');
        /*
            The title attribute isn't really supported in I've submitted
            a patch to plugins/editors/tinymce/tinymce.php to add support. 
        */
        $button->title = JText::_('COM_CONNECTDAILY_INSERT_CALENDAR');
        $button->name = 'calendar-3';
        $button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";

        return $button;
    }
}

