<?php
/*
# mod_iframe_pro - Extension of the standard wrapper
# ------------------------------------------------------------------------
# Author    it-conserv.de
# Copyright (C) 2016 it-conserv.de All Rights Reserved.
# License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# standard elements is Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.
# Websites: it-conserv.de
# ------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

// Load CSS/JS
$document = JFactory::getDocument();
$document->addScript('https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js');

// Load basic define settings
$ifp_css='
.ifp-wrapper-'.$uniqid.'{
	position: relative;
	margin-top: '.$margin_top.';
	margin-bottom: '.$margin_bottom.';
	margin-right: '.$margin_right.';
	margin-left: '.$margin_left.';
	overflow: hidden !important;
}

.ifp-wrapper-'.$uniqid.' .ifp-map{
	position: relative;
	width: '.$width.';
	height: '.$height.';
	overflow: hidden;
}

.ifp-wrapper-'.$uniqid.' .ifp-overlay{
	background-color: '.$bg_color.';
	position:relative;
	cursor:pointer;
	z-index: 100;
	width: '.$width.';
	height: '.$height.';
	top: '.$height.';
	margin-top: -'.$height.';
}

.ifp-wrapper-'.$uniqid.' .ifp-overlay,
.ifp-wrapper-'.$uniqid.' .ifp-overlay.ifp-open span,
.ifp-wrapper-'.$uniqid.' .ifp-overlay:after{
  -webkit-transition: all 0.4s ease;
  -moz-transition : all 0.4s ease;
  transition : all 0.4s ease;
 }
 
.ifp-wrapper-'.$uniqid.' .ifp-overlay span{
	position: absolute;
	display: none;
	font-size: 30px;
	right: 0;
	bottom: 0;
	padding: 0 0 0 10px;
	background-color: rgba(100,100,100,0.5);;
}

.ifp-wrapper-'.$uniqid.' .ifp-overlay.ifp-open{
	top: 30px;
}
.ifp-wrapper-'.$uniqid.' .ifp-overlay.ifp-open span i,
.ifp-wrapper-'.$uniqid.' .ifp-overlay.ifp-open span i::before{
	color: #ffffff !important;
}

.ifp-wrapper-'.$uniqid.' .ifp-overlay.ifp-open span{
	display: inline-block;
}

/* **** Tooltip **** */
.ifp-wrapper-'.$uniqid.' .ifp-overlay:after {
	content: attr(data-tooltip);
	color: #fff;
	text-align: center;
	line-height: 1.5em;
	font-size: 1em;
	opacity: 0;
}
.ifp-wrapper-'.$uniqid.' .ifp-overlay:after {
  position: absolute;
  bottom: 30px;
  '.$tt_align.': 10px;
  background-color: '.$bg_color.';
  padding: 3px 10px;
  -webkit-border-radius: 5px;
  -moz-border-radius : 5px;
  border-radius : 5px;
}
.ifp-wrapper-'.$uniqid.' .ifp-overlay:hover:after{
  opacity: '.$tt.';
}

';

// Put styling in header
$document->addStyleDeclaration($ifp_css);

$ifp_script='
<script type="text/javascript">
(function ($) {
$(document).ready(function(){
    $(".ifp-wrapper-'.$uniqid.' .ifp-overlay").click(function(){
        $(".ifp-wrapper-'.$uniqid.' .ifp-overlay").toggleClass("ifp-open");
    });
});
})(jQuery);
</script>
';
echo $ifp_script;
?>

<div class="ifp-wrapper-<?php echo $uniqid; ?>">
	<div class="ifp-overlay" data-tooltip="<?php echo $tt_text; ?>"><span><i class="fa fa-times"></i></span></div>
	<div class="ifp-map">
		<iframe 
			name="<?php echo $target; ?>" 
			src="<?php echo $url; ?>"
			width="<?php echo $width; ?>"
			height="<?php echo $height; ?>"
			scrolling="<?php echo $scroll; ?>"
			frameborder="<?php echo $frameborder; ?>" >
			<?php echo JText::_('IF_NO_IFRAMES'); ?>
		</iframe>
	</div>
</div>