<?php
/**
 * ConnectDaily Events Calendar Package Install Script
 *  
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (6/11/16) 
 */
defined('_JEXEC') or die;
/**
 * Installer/Uninstaller Script.
 * 
 * @author gsexton (6/17/16)
 */
class pkg_connectdailyInstallerScript {

    private function log($msg){
       //   file_put_contents('php://stderr', print_r("\n$msg\n", true));
    }

    /**
     * Constructor
     *
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     */
    public function __construct(JAdapterInstance $adapter) {
        $this->log(get_class($this).".__construct()");
    }

    /**
     * Called before any type of action
     *
     * @param   string  $route  Which action is happening (install|uninstall|discover_install|update)
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     *
     * @return  boolean  True on success
     */
    public function preflight($route, JAdapterInstance $adapter) {
        $this->log(get_class($this).".preflight()");
        return true;
    }

    /**
     * Called after any type of action
     *
     * @param   string  $route  Which action is happening (install|uninstall|discover_install|update)
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     *
     * @return  boolean  True on success
     */
    public function postflight($route, JAdapterInstance $adapter) {
        $this->log(get_class($this).".postflight()");
        if ("install"===$route || "discover_install"===$route) {
            /*
                Direct the user to the configuration page.
            */
            $destPath=JRoute::_('index.php?task=settings.showsettings&component=com_connectdaily&option=com_connectdaily',false);
            JFactory::getApplication()->redirect($destPath);
        }
        return true;
    }

    /**
     * Called on installation
     *
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     *
     * @return  boolean  True on success
     */
    public function install(JAdapterInstance $adapter) {
        $this->log(get_class($this).".install()");
        $this->enablePlugin();
        return true;
    }

    private function enablePlugin(){
        $this->log(get_class($this).".enablePlugin()");
        $db  = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->update('#__extensions');
        $query->set($db->quoteName('enabled') . ' = 1');
        $query->where($db->quoteName('element') . ' like ' . $db->quote('%connectdaily%'));
        $db->setQuery($query);
        $db->execute();
    }

    /**
     * Called on update
     *
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     *
     * @return  boolean  True on success
     */
    public function update(JAdapterInstance $adapter) {
        $this->log(get_class($this).".update()");
        $this->enablePlugin();
        return true;
    }

    /**
     * Called on uninstallation
     *
     * @param   JAdapterInstance  $adapter  The object responsible for running this script
     */
    public function uninstall(JAdapterInstance $adapter) {
        $this->log(get_class($this).".uninstall()");
        return true;
    }
}
