<?php 
/**
 * ConnectDaily Events Calendar Content Plugin 
 * 
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
defined('_JEXEC') or die; 
jimport('connectdaily.class-cdaily-datetime');
$ver=new JVersion();
$plugin=CDailyJoomlaPlugin::getInstance();
$settings=$plugin->getSettings();
$supportInfo=$ver->PRODUCT." Version: ". $ver->RELEASE.'.'.$ver->DEV_LEVEL.
    "\nSite URL: " . $plugin->getSiteUrl().
    "\nLanguage: ".$settings->language.
    "\nTime Zone: ".$settings->timezone_string.
    "\n\nCalendar URL: ".$settings->url.
    "\nPlugin Version: ".CDailyJoomlaPlugin::PLUGIN_NAME . ' v'.CDailyJoomlaPlugin::VERSION_NUMBER.
    "\n\nPHP Version: " .phpversion().'/'.PHP_OS;

$supportMail='support@mhsoftware.com?Subject='.
    rawurlencode('connectDaily Joomla! Plugin').
    "&amp;Body=".
    rawurlencode("\n\n\n".$supportInfo);
/*
    This next major block tries to get the times in Local Time
    for the end user to view.
 
    For people like Australia, things are kind of hinky
    because
*/
$tzDenver=new DateTimeZone('America/Denver');
$tzServer=$tzDenver;
try {
    $tzServer=new DateTimeZone($settings->timezone_string);
} catch (Exception $ex){
    $tzServer=$tzDenver;
}

$date=new CDDateTime();
$dLocal=new CDDateTime();
$dLocal->setTimezone($tzServer);

$date->setTimezone($tzDenver);
while ($date->getDow()==0 || $date->getDow()==7) {
    $date->incrementDays(1);
}
$timestr='<table><caption>Hours ('.$tzServer->getName().')</caption>';

$fmt=$settings->time_format;
if (empty($fmt)) {
    $fmt='g:i a';
}
for ($i=0; $i < 7; $i++) {
    if ($date->getDow()==0 || $date->getDow()==6) {
        $date->incrementDays(1);
        continue;
    }
    $date->setTime(9,0,0);
    $dLocal->setTimestamp($date->getTimestamp());
    $timestr.='<tr><td style="padding-right: 1.5em;">'.$dLocal->format('D').'</td><td>'.$dLocal->format($fmt);
    $date->setTime(17,30,0);
    $dLocal->setTimestamp($date->getTimestamp());
    $timestr.=' - '. $dLocal->format($fmt).'</td></tr>';
    $date->incrementDays(1);
}
$timestr.='</table>';

?>
<div class="CDpostbox" id="CDailyInstructions" style="padding: 1em;">
    <h3>Contact Support</h3>
    We take support seriously. You can get support for connectDaily via any of the methods below.
    <dl>
        <!--
        <dt>Support Forums</dt>
        <dd><a href="http://www.connectdaily.com/forums/joomla-calendar-plugin-forum/" target=_blank>http://www.connectdaily.com/forums/joomla-calendar-plugin-forum/</a></dd>
        -->
        <dt>EMail</dt>
        <dd><a href="mailto:<?php echo $supportMail; ?>">support@mhsoftware.com</a></dd>
        <dt>Telephone</dt>
        <dd><a href="tel:+13034389585">+1 303 438 9585</a>
        <br><br>
        <?php echo $timestr; ?>
        </dd>

    </dl>
</div>
<div class="CDSidebar" style="padding: 1em; width: 40em;" >
    <H3>System Information</h3>
    Please provide this information to support staff when sending <br>
    an email or posting to the forums.<br><br>
    <form>
        <textarea onclick="this.select();" rows=10 style="width: 30em;"><?php echo $supportInfo; ?></textarea>
    </form>
</div>
<form name="adminForm" id="adminForm">
    <!-- this is a dummy necessary for toolbar buttons to work. -->
    <input type="hidden" name="task" value="settings.showsettings">
    <input type="hidden" name="option" value="com_connectdaily">
</form>

