<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla view library
jimport('joomla.application.component.view');
jimport('connectdaily.class-cdaily-external-link');

/**
 * ConnectDaily Events Calendar Content Plugin
 *  
 * @package Joomla.Component
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
class connectdailyViewSettings extends JViewLegacy {
    /**
     * connectDaily view display method
     * @return void
     */
    function display($tpl = null) {

        $this->settings=$this->get('Settings');
        $this->plugin=$this->get('Plugin');
        $aMessages=$this->plugin->getNotices()->getMessages('settings');
        foreach ($aMessages as $msg) {
            JFactory::getApplication()->enqueueMessage($msg,'error');
        }

        $this->termsURL = "javascript:CDaily.showTerms();";
        $this->termsTxt = JText::sprintf(JText::_('COM_CONNECTDAILY_TERMSANDCONDITIONS_TEXT'), $this->termsURL);
        $this->is_configured = !empty($this->settings->url);
        $this->configuredSetting = $this->is_configured ? 'Y' : 'N';
        $this->language = JFactory::getLanguage();
        $this->cacheMsg = JText::sprintf(JText::_('COM_CONNECTDAILY_DISABLE_CACHE'),
                                         CDailyPlugin::CACHE_DISABLE_PERIOD_SECONDS,
                                         JText::_($this->plugin->isCacheEnabled() ? 'COM_CONNECTDAILY_ENABLED' : 'COM_CONNECTDAILY_DISABLED'));

        $this->ajaxURL = $this->plugin->getSiteUrl() . 'administrator/index.php?option=com_connectdaily&task=doSSOAjax&format=raw';

        $user=$this->plugin->getCurrentUser();
        $this->email = empty($user->user_email) ? $this->getSiteEmail() : $user->user_email;

        // Set the toolbar
        $this->addToolBar();

        // Display the template
        parent::display($tpl);

        // Set the document
        $this->setDocument();
    }

    /**
     * Setting the toolbar
     */
    protected function addToolBar() {
        JToolBarHelper::title(JText::_('COM_CONNECTDAILY_COMPONENT').' - '
                            .JText::_('COM_CONNECTDAILY_OPTIONS'), 'connectdaily');
        $tb = JToolBar::getInstance();
        if ($this->is_configured) {
            $tb->appendButton('ExternalLink', 'enter', JText::_('COM_CONNECTDAILY_LOGIN'), 'return CDaily.doSingleSignon();');
        }

        JToolBarHelper::custom('support.showsupport', 'phone-2', 'phone-2', JText::_('COM_CONNECTDAILY_SUPPORT'), false);

        // JToolBarHelper::custom('tutorials.showtutorial', 'video', 'video', JText::_('COM_CONNECTDAILY_TUTORIALS'), false);
        $tb->appendButton('ExternalLink', 'help', JText::_('JTOOLBAR_HELP'), 'http://livedemo.mhsoftware.com/manual/en/pageFinder.html?page=JoomlaCalendarPlugin.html');
        JToolbarHelper::spacer();
        JToolbarHelper::apply('settings.apply');
        if ($this->is_configured) {
            JToolbarHelper::save('settings.save');
        }
        JToolbarHelper::cancel();

    }
    /**
     * Method to set up the document properties
     *
     * @return void
     */
    protected function setDocument() {
        $document = JFactory::getDocument();
        $document->setTitle(JText::_('COM_CONNECTDAILY_COMPONENT')
                            .' - '
                            .JText::_('COM_CONNECTDAILY_OPTIONS')
                            );
    }

    public function getDaysOfWeekDropdown($start, $current) {
        $d = JFactory::getDate();
        $di = new DateInterval('P1D');
        while ($d->format('w', true) != $start) {
            $d = $d->add($di);
        }
        $s = '<select id="IDCDailyStartOfWeek" name="cdaily_start_of_week">';
        for ($i = 0; $i < 7; $i++) {
            $temp = $d->format('w', true);
            $s .= '<option value="' . $temp . '"';
            if ($temp == $current) {
                $s .= ' selected';
            }
            $s .= '>' . $d->format('l', true, true);
            $d->add($di);
        }
        $s .= '</select>';
        return $s;
    }
}
