#!/bin/sh

CPP_OPTS="-P -traditional"
VERSIONS="PGSQL MSSQL MYSQL"
DOS_FILES="MSSQL"
SCRIPTS="schema.in uninstall.in"
if [ ! -f cleaner.class ]; then
	javac -classpath . cleaner.java
fi
for VERSION in $VERSIONS; do
	echo "Processing $VERSION"
	if [ ! -d $VERSION ]; then
		mkdir $VERSION
	fi
        for S in $SCRIPTS; do
         SNAME=${S%%.*}
	 cpp $CPP_OPTS -D$VERSION $S | java cleaner > $VERSION/$SNAME.sql
        done
done
for VERSION in $DOS_FILES; do
	find $VERSION -type f -name "*.sql" -exec unix2dos "{}" \;
done
rm -f cleaner.class
