<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla view library
jimport('joomla.application.component.view');

/**
 * ConnectDaily Events Calendar Content Plugin
 *  
 * @package Joomla.Component
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
class ConnectDailyControllerSettings extends JControllerLegacy {

    public function __construct($config) {
        /*
            I'm calling this via a toolbar button, and you can't set the view there,
            so I have to override it here.
        */
        $config['default_view'] = 'settings';
        parent::__construct($config);
    }

    public function execute($task) {
        $plugin = CDailyJoomlaPlugin::getInstance();
        $req = JFactory::getApplication()->input;
        $save = false;
        if ($req->get('form_submit') === 'Y' && $task != 'cancel') {
            $save = self::processPost($plugin);
        }
        if ($task == 'settings.save' && $save) {
            $this->setRedirect(JRoute::_('index.php?option=com_connectdaily'));
            return;
        } else {
            $task = 'settings.showsettings';
        }
        parent::execute($task);
    }

    public static function processPost($plugin) {
        /*
            The two cases are:
         
            1) We're provisioning a new calendar
            2) We're changing our settings.
        */
        $app = JFactory::getApplication();
        $req = $app->input;
        $result = true;
        if ('Y' === $req->get('form_submit', 'N')) {
            $radio = $req->get('rgCalendarChoice', '');
            if (empty($radio) || $radio == 'use_existing') {
                $result = self::saveSettings($plugin, $req);
            } else {
                // This is a provision host.
                $plugin->clearLastError();
                if ('1' === $req->get('chkCDTermsAndConditions')) {
                    $result = $plugin->provisionCalendarSystem($req->get('organization_name', 'Joomla User','string'),
                                                               $req->get('site_url', $plugin->getSiteUrl(), 'string'),
                                                               $req->getInt('provision_resources',0)===1,
                                                               $req->getInt('provision_publicadd',0)===1,
                                                               $req->get('provision_email','user@example.com','string')
                                                               );
                    
                    if ($result == null) {
                        $s = $plugin->getLastError();
                        if (!empty($s)) {
                            $result = false;
                            $app->enqueueMessage($s,'error');
                        }
                    } else if (array_key_exists('error', $result) && $result['error'] != 0) {
                        $app->enqueueMessage($result['error_message'],'error');
                        $result = false;
                    }
                } else {
                    $app->enqueueMessage(JText::_('COM_CONNECTDAILY_ACCEPT_TC'), 'error');
                }
            }

        }
        return $result;
    }

/**
 * Save our request onto settings, 
 */
    public static function saveSettings($plugin, $req) {
        $settings = $plugin->getSettings();
        $old = json_decode(json_encode($settings));
        $settings->start_of_week = intval($req->get('cdaily_start_of_week', 1, 'int'));
        $oldURL = $settings->url;
        $fields = array(
            'url',
            'username',
            'password',
            'date_format',
            'time_format',
            'datetime_format',
            'skip_resource_types'
            );
        foreach ($fields as $field) {
            $settings->{$field}
                = trim($req->get('cdaily_' . $field, '', 'string'));
        }
        if ($oldURL != $settings->url) {
            $settings->url = $plugin->secureURLIfPossible($settings->url);
        }
        if ('1' == $req->get('cdaily_disable_cache', '0')) {
            $plugin->disableCache(false);
        }
        $plugin->saveSettings($settings);

        return self::handleSettingsChange($plugin, $old, $settings);
    }

    private static function handleSettingsChange($plugin, $previousValues, $newValues) {
        /*
            If the URL or other things have changed, we need to re-validate.
        */
        $newValues->token = null;
        if (property_exists($newValues, 'user_id')) {
            unset($newValues->user_id);
        }
        if (property_exists($newValues, 'etoken')) {
            unset($newValues->etoken);
        }
        $retval = true;
        $result = null;
        $plugin->clearLastError();
        if (empty($newValues->url)) {
            // There's no URL value. Not much we can do.
        } else if ($previousValues->url == $newValues->url) {
            $pwchange = $plugin->isPasswordChange($previousValues, $newValues->username, $newValues->password);
            if ($pwchange) {
                $result = $plugin->changeUserPassword($previousValues->username, $previousValues->password, $newValues->username, $newValues->password);
                if ($result->error == 0) {
                    $newValues->token = '&user_id=' . $result->user_id . '&etoken=' . $result->etoken;
                    $newValues->user_id = $result->user_id;
                    $newValues->etoken = $result->etoken;
                } else {
                    $retval = false;
                }
            } else {
                if (empty($newValues->username)) {
                    // If there's no username/password, fetchSecurityToken doesn't work. Create an empty $result.
                    $result=new stdClass;
                } else {
                    $result = $plugin->fetchSecurityToken($newValues);
                }
            }
        } else {
            $result = $plugin->fetchSecurityToken($newValues);
        }

        $plugin->saveSettings($newValues);
        if ($result == null) {
            $retval = false;
            $s = $plugin->getLastError();
            if ($s != null) {
                JFactory::getApplication()->enqueueMessage($s,'error');
            }
        } else if (property_exists($result, 'error') && $result->error != 0) {
            $retval = false;
            JFactory::getApplication()->enqueueMessage($result->error_message,'error');
        }
        $plugin->purgeTransients(true);
        return $retval;
    }
}
