<?php
/**
 * ConnectDaily Events Calendar Content Plugin 
 * 
 * @package Joomla.Plugin 
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */

defined('_JEXEC') or die;

jimport('connectdaily.CDailySSO');

/**
 * This class is a helper to process AJAX single-signon 
 * requests. We can't use com_ajax because it lives in 
 * site-land, and not administrator-land. 
 * 
 * @author gsexton (4/6/16)
 */
class CDailyJoomlaSSOHelper {

    /**
     * Process a request for SSO. Essentially, we just return a URL 
     * to the client. 
     *  
     * @return void 
     */
    public static function processSSORequest($plugin, $req) {
        $callback=$req->get('callback', '');

        $user=JFactory::getUser();

        if ($user->guest) {
            /*
                Don't allow Single-Signon from unauthenticated users.
            */
            $plugin->logError(get_class()."->processSSORequest() - Call from Guest");
            return $callback.'({"error" : "User Not Logged In!"});';
        }

        $ssoHelper = new CDailySSO($plugin);
        $result = '';
        try {
            $result = $ssoHelper->processClientSSORequest();
        } catch (CDailySSOException $ssoe) {
            $result = $ssoHelper->getStandardLogin();
        } catch (Exception $ex) {
            $result = $ssoHelper->getStandardLogin();
        }

        $result = $callback . '(' . $result . ');';

        echo $result;
    }
}
